/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UserSettingsBean;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings;
import com.ibm.hwmca.fw.settings.user.StatusBackgroundConstants;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;

public class ObjectBackgroundSettingsBean
extends UserSettingsBean {
    private String[] m_sColorsSelection;
    private String m_sStatusChoice;
    private ValueDescriptor[] m_vdStatusChoice;
    private boolean m_bUsePatternsToggle;
    private String[] m_sPatternsSelection;
    private int numStatus = 0;
    private int numAttentions = 0;
    private ObjectId[] attentionTaskObjectIds;
    private String[] statusChoices;
    private static final String TRACE_MASKT = "HUSTBE T";
    private static final String TRACE_MASKF = "HUSTBE F";
    private static final String TRACE_MASKD = "HUSTBE D";
    private static final String STATUS_CHOICE_KEY = "StatusChoice.";
    private ObjectBackgroundSettings settings;
    private ObjectBackgroundSettings savedSettings;

    public void setColorsSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettingsBean.setColorsSelection()");
        if (selected != null && selected.length > 0) {
            this.m_sColorsSelection[0] = selected[0];
            this.changeImage();
        }
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettingsBean.setColorsSelection()");
    }

    public String[] getColorsSelection() {
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettingsBean.getColorsSelection(), selection is " + this.m_sColorsSelection[0]);
        return this.m_sColorsSelection;
    }

    public ValueDescriptor[] getStatusChoiceList() {
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettingsBean.getStatusChoiceList(), number of Status is " + this.m_vdStatusChoice.length);
        return this.m_vdStatusChoice;
    }

    public void setStatusChoice(String s) throws IllegalUserDataException {
        this.m_sStatusChoice = s;
        this.changeImageSelection();
    }

    public String getStatusChoice() {
        return this.m_sStatusChoice;
    }

    public void setUsePatternsToggle(boolean b) throws IllegalUserDataException {
        this.m_bUsePatternsToggle = b;
        this.settings.setUseColorsStatus(!this.m_bUsePatternsToggle);
        this.settings.setUseColorsOther(!this.m_bUsePatternsToggle);
        this.changeImageSelection();
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettingsBean.setUsePatternsToggle(),  new value is " + this.m_bUsePatternsToggle);
    }

    public boolean isUsePatternsToggle() {
        return this.m_bUsePatternsToggle;
    }

    public void setPatternsSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettingsBean.setPatternsSelection()");
        if (selected != null && selected.length > 0) {
            this.m_sPatternsSelection[0] = selected[0];
            this.changeImage();
        }
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettingsBean.setPatternsSelection()");
    }

    public String[] getPatternsSelection() {
        return this.m_sPatternsSelection;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettingsBean.load()");
        this.m_sColorsSelection = new String[1];
        this.m_sColorsSelection[0] = "";
        this.m_sPatternsSelection = new String[1];
        this.m_sPatternsSelection[0] = "";
        Status[] status = this.settings.getStatus();
        UIInfo[] attns = this.settings.getAttentionUIInfos();
        this.m_vdStatusChoice = new ValueDescriptor[status.length + attns.length + 2];
        this.initPanelData();
        this.savedSettings = (ObjectBackgroundSettings)this.settings.clone();
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettingsBean.load()");
    }

    public void save() {
    }

    void initPanelData() {
        this.m_bUsePatternsToggle = this.settings.usePatternsStatus();
        this.statusChoices = new String[this.m_vdStatusChoice.length];
        Status[] status = this.settings.getStatus();
        this.numStatus = status.length;
        int next = 0;
        int i = 0;
        while (i < status.length) {
            Trace.trace(TRACE_MASKD, "   next Status is " + status[i].toString());
            this.statusChoices[next] = status[i].getUIInfo().getName();
            this.m_vdStatusChoice[next] = new ValueDescriptor(STATUS_CHOICE_KEY + String.valueOf(next), this.statusChoices[next]);
            ++next;
            ++i;
        }
        this.attentionTaskObjectIds = this.settings.getAttentionTaskObjectIds();
        this.numAttentions = this.attentionTaskObjectIds.length;
        int i2 = 0;
        while (i2 < this.attentionTaskObjectIds.length) {
            this.statusChoices[next] = this.settings.getAttentionUIInfo(this.attentionTaskObjectIds[i2]).getName();
            this.m_vdStatusChoice[next] = new ValueDescriptor(STATUS_CHOICE_KEY + String.valueOf(next), this.statusChoices[next]);
            ++next;
            ++i2;
        }
        this.statusChoices[next] = this.settings.getAcceptableText().toString();
        this.m_vdStatusChoice[next] = new ValueDescriptor(STATUS_CHOICE_KEY + String.valueOf(next), this.statusChoices[next]);
        this.statusChoices[++next] = this.settings.getUnacceptableText().toString();
        this.m_vdStatusChoice[next] = new ValueDescriptor(STATUS_CHOICE_KEY + String.valueOf(next), this.statusChoices[next]);
        ++next;
        this.m_sStatusChoice = status[0].getUIInfo().getName();
        this.changeImageSelection();
    }

    String getImageSelectionName(String imageName) {
        Trace.trace(TRACE_MASKD, "-> ObjectBackgroundSettings.getImageSelectionName(), imageName is " + imageName);
        StringBuffer buffer = new StringBuffer(imageName);
        buffer.delete(0, buffer.lastIndexOf("/") + 1);
        buffer.setLength(buffer.indexOf("."));
        buffer.append("Item");
        String s = buffer.substring(0, 1).toUpperCase();
        buffer.replace(0, 1, s);
        Trace.trace(TRACE_MASKD, "<- ObjectBackgroundSettings.getImageSelectionNameForStatus(), result is " + buffer.toString());
        return buffer.toString();
    }

    void changeImageSelection() {
        String imageName = this.getImageNameForChoice(this.m_sStatusChoice);
        if (this.m_bUsePatternsToggle) {
            this.m_sPatternsSelection[0] = this.getPanelName() + this.getImageSelectionName(imageName);
        } else {
            this.m_sColorsSelection[0] = this.getPanelName() + this.getImageSelectionName(imageName);
        }
    }

    String getImageNameForChoice(String choice) {
        Trace.trace(TRACE_MASKD, "-> ObjectBackgroundSettings.getImageNameForChoice(), choice is " + choice);
        String result = null;
        int index = 0;
        while (index < this.statusChoices.length) {
            if (choice.equals(this.statusChoices[index])) break;
            ++index;
        }
        Trace.trace(TRACE_MASKD, "   index is " + index);
        result = index < this.numStatus ? this.settings.getBackgroundImageName(this.getStatusForName(choice)) : (index == this.m_vdStatusChoice.length - 1 ? this.settings.getUnacceptableImageName() : (index == this.m_vdStatusChoice.length - 2 ? this.settings.getAcceptableImageName() : this.settings.getAttentionImageName(this.attentionTaskObjectIds[index - this.numStatus])));
        Trace.trace(TRACE_MASKD, "<- ObjectBackgroundSettings.getImageNameForChoice()");
        return result;
    }

    Status getStatusForName(String name) {
        Status result = null;
        Status[] status = this.settings.getStatus();
        int i = 0;
        while (i < status.length) {
            String statusName = status[i].getUIInfo().getName();
            if (statusName.equals(name)) {
                result = status[i];
                break;
            }
            ++i;
        }
        return result;
    }

    void changeImage() {
        String selection;
        Trace.trace(TRACE_MASKD, "-> ObjectBackgroundSettings.changeImage()");
        String string = selection = this.m_bUsePatternsToggle ? this.m_sPatternsSelection[0] : this.m_sColorsSelection[0];
        if (selection.indexOf(".") > -1) {
            selection = selection.substring(selection.indexOf(".") + 1);
        }
        String[] imageNames = this.m_bUsePatternsToggle ? StatusBackgroundConstants.getPatternImageFileNames() : StatusBackgroundConstants.getColorImageFileNames();
        String imageName = this.getImageNameFromSelection(selection);
        int i = 0;
        while (i < imageNames.length) {
            Trace.trace(TRACE_MASKD, "   imageNames[i] is " + imageNames[i]);
            String next = imageNames[i].substring(imageNames[i].lastIndexOf("/") + 1);
            if (next.equals(imageName)) {
                this.updateSettingsImage(this.m_sStatusChoice, imageNames[i]);
                break;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "<- ObjectBackgroundSettings.changeImage()");
    }

    void updateSettingsImage(String choice, String imageName) {
        Trace.trace(TRACE_MASKD, "-> ObjectBackgroundSettings.updateSettingsImage(), choice=" + choice + ", imageName=" + imageName);
        int i = 0;
        while (i < this.m_vdStatusChoice.length) {
            Trace.trace(TRACE_MASKD, "   m_vdStatusChoice[i].getTitle()=" + this.m_vdStatusChoice[i].getTitle());
            if (this.m_vdStatusChoice[i].getTitle().equals(choice)) {
                if (i < this.numStatus) {
                    this.settings.setBackgroundImageName(this.getStatusForName(choice), imageName);
                    break;
                }
                if (i == this.m_vdStatusChoice.length - 1) {
                    this.settings.setUnacceptableImageName(imageName);
                    break;
                }
                if (i == this.m_vdStatusChoice.length - 2) {
                    this.settings.setAcceptableImageName(imageName);
                    break;
                }
                this.settings.setAttentionImageName(this.attentionTaskObjectIds[i - this.numStatus], imageName);
                break;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "<- ObjectBackgroundSettings.updateSettingsImage()");
    }

    String getImageNameFromSelection(String selection) {
        Trace.trace(TRACE_MASKD, "   selection is " + selection);
        StringBuffer buffer = new StringBuffer(selection.toLowerCase());
        buffer.delete(0, buffer.lastIndexOf(".") + 1);
        buffer.setLength(buffer.indexOf("item"));
        buffer.append(".gif");
        Trace.trace(TRACE_MASKD, "   getImageNameFromSelection() returning " + buffer.toString());
        return buffer.toString();
    }

    String getPanelName() {
        return this.isUsePatternsToggle() ? "PatternsPanel." : "ColorsPanel.";
    }

    protected boolean hasSettingsChanged() {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettingsBean.hasSettingsChanged()");
        boolean result = !this.settings.equals(this.savedSettings);
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettingsBean.hasSettingsChanged(), result is " + result);
        return result;
    }

    protected void updateUserSettings() {
        Trace.trace(TRACE_MASKF, "<> ObjectBackgroundSettingsBean.updateUserSettings()");
        this.savedSettings = (ObjectBackgroundSettings)this.settings.clone();
    }

    protected UserSettings getUserSettings() {
        return this.settings;
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettingBean.update()");
        this.setUserSettings((ObjectBackgroundSettings)object);
        this.initPanelData();
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettingBean.update()");
    }

    protected void resetUserSettings(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> ObjectBackgroundSettingsBean.resetUserSettings()");
        this.settings = (ObjectBackgroundSettings)this.savedSettings.clone();
        this.initPanelData();
        Trace.trace(TRACE_MASKF, "<- ObjectBackgroundSettingsBean.resetUserSettings()");
    }

    public void setUserSettings(ObjectBackgroundSettings settings) {
        this.settings = settings;
    }
}

